# Randomize Class Names in Astro Web Framework

If you're wanting to have your class names in your Astro website randomized, no extra integrations or packages are needed. This can be done simply using the module method.

## Module Method

Your CSS file needs to have the module name in it, such as `*.module.css`. For this example, we'll use `index.module.css`. 

```css
/* index.module.css */
.card {
    background: #121212;
    color: #eee;
    border-radius: 3px;
    border: 1px #232323 solid;
}
.version {
    font-size: 12px;
    text-align: center;
}
```

In your Astro file, import the CSS module file and change your class names to use it directly, here's an example with the CSS file I just showed:

```jsx
---
import Style from "./index.module.css"
---

<div class={Style.card}>
    <h1>Card Title</h1>
    <p>Card content</p>
</div>
<p class={Style.version}>v0.0.1</p>
```

> Classname for card output as `_card_1mdgr_2` and version as `_version_1mdgr_2`. The `_1mdgr_` changes when you make changes to the CSS file, I assume it uses a hash method of some sort. 

If you need to add another class name onto the class attribute, do something like this:
```jsx
<p class={"extra-classname " + Style.card}</p>
```

or

```jsx
<p class={`extra-classname ${Style.card}`}></p>
```