When building a custom video player, it will likely not work for end-users that have decided to disable JavaScript in their web browser. To get around this, it's best to add a fallback that'll allow them to switch over to the web browser's native player. 

To pull this off, we'll take advantage of the HTML tag known as `details` and `noscript`. 

## Detect JavaScript is Disabled

First, we need to tell if JavaScript is disabled, we can use the `noscript` tag. Anything used within a `noscript` tag is shown if JavaScript is not present. 

```html
<noscript>If you're seeing this, JavaScript is not enabled.</noscript>
```

## Toggle Button

We'll create a button using the `details` tag that'll show the native video player.

```html
<details>
  <summary>Show Native Player</summary>
  <video src="video.mp4"></video>
</details>
```

## Full Example

<p>Preview from Zorn v0.7 Development</p>

![Preview](https://ocean.sudovanilla.org/media/gifs/7fea948c65dc3a07.gif)

Putting it altogether, with styling:
```html

<noscript>
    <div style="background: #ffffff1f;padding: 12px 24px;font-size: 14px;aspect-ratio: 16/9;display: flex;justify-content: center;;border-radius: 12px; position:relative; display: flex; flex-direction: column;">
        <p>This web video player requires JavaScript in order to function properly. Please enable JavaScript in your web browser.</p>
        <details>
            <summary style="background: #00000082;width: max-content;border-radius: 3rem;padding: 12px 24px;margin: auto;cursor: pointer;">Use native player instead</summary>
            <video style="width: 100%" border-radius: 12px;" controls poster="poster.png" src="video.mp4"/>
        </details>
        <style>
            details[open] {
                position: absolute;
                top: 0px;
                left: 0px;
                width: 100%;
                summary {
                    display: none;
                }
                video {
                    pointer-events: all !important;
                }
            }
        </style>
    </div>
    <style>.yourcustomplayer {display: none}</style>
</noscript>
```