// Find elements
var SyncVideo = document.querySelector("#main-video")
var SyncAudio = document.querySelector("#main-audio")

// Object for synchronization of multiple media/sources
if (typeof window.MediaController === "function") {
    var controller = new MediaController()
    SyncVideo.controller = controller
    SyncAudio.controller = controller
} else {
    controller = null
}

// Run SyncAudio and SyncVideo simultaneously
SyncVideo.addEventListener(
    "play",
    function () {
        if (!controller && SyncAudio.paused) {
            SyncAudio.play()
        }
    },
    false,
)

// Pause/Play and Buffering
SyncVideo.addEventListener("waiting", () => {
    // If SyncVideo is buffering
    SyncAudio.pause()
})
SyncVideo.addEventListener("playing", () => {
    // If SyncVideo is done buffering
    SyncAudio.play()
    SyncTimestamp()
})

SyncVideo.addEventListener(
    "pause",
    function () {
        if (!controller && !SyncAudio.paused) {
            SyncAudio.pause()
        }
    },
    false,
)

// When Media Ends
SyncVideo.addEventListener(
    "ended",
    function () {
        if (controller) {
            controller.pause()
        } else {
            SyncVideo.pause()
            SyncAudio.pause()
        }
    },
    false,
)

// Seekbar
function SyncTimestamp() {
    SyncAudio.currentTime = SyncVideo.currentTime
}