# My Setup for Alpine Linux on Framework 13

```ash
# Install GNOME Desktop - Use 'gdm' to launch after installation
setup-desktop gnome

# Change GNOME Settings
gsettings set org.gnome.desktop.interface color-scheme "prefer-dark"
gsettings set org.gnome.desktop.peripherals.mouse accel-profile 'flat'
gsettings set org.gnome.desktop.interface enable-hot-corners false
gsettings set org.gnome.desktop.privacy recent-files-max-age 7
gsettings set org.gnome.desktop.privacy old-files-age 7
gsettings set org.gnome.desktop.privacy remove-old-temp-files true
gsettings set org.gnome.desktop.privacy remove-old-trash-files true
gsettings set org.gnome.desktop.interface enable-hot-corners false

# Enable Community Repositories
setup-apkrepos -c
apk update

# Install Packages
apk add docker docker-cli-compose git bash curl wget unzip zip flatpak add gnome-software-plugin-flatpak fastfetch linux-firmware bluez acpid zzz bash-completion sudo bash-doc pipewire wireplumber gst-plugin-pipewire font-terminus font-inconsolata font-dejavu font-noto font-noto-cjk font-awesome font-noto-extra networkmanager networkmanager-cli networkmanager-wifi pipewire-jack pipewire-alsa dbus-openrc

# Setup Docker
rc-update add docker default
service docker start
addgroup ${USER} docker
rc-update add cgroups

# Setup Bluetooth and Audio Service
setup-devd udev
adduser $USER lp
rc-service bluetooth start
rc-update add bluetooth default
rc-service dbus start
rc-update add dbus default

# Setup Pipewire
rc-update add apk-polkit-server default && rc-service apk-polkit-server start

# Setup Networking - If network doesn't work after this, use 'setup-interfaces -r -a' to force reconnect.
setup-devd udev
adduser korbs plugdev
rc-service networkmanager start
rc-update add networkmanager default
nano /etc/NetworkManager/NetworkManager.conf # See 'NetworkManager.conf` file belowc
rc-service networking stop
rc-service wpa_supplicant stop
rc-service networkmanager restart
rc-update add networkmanager
rc-update del networking boot
rc-update del wpa_supplicant boot

# Setup Bash
source /etc/bash/bash_completion.sh

# Setup "sudo" for me
echo '%wheel ALL=(ALL) ALL' > /etc/sudoers.d/wheel
adduser korbs wheel
sudo -lU korbs

# Remove Stock Apps
apk del gnome-boxes gnome-calendar gnome-calendar-lang gnome-characters gnome-characters-lang gnome-chess gnome-chess-doc gnome-chess-lang gnome-clocks gnome-clocks-doc gnome-clocks-lang gnome-connections gnome-connections-doc gnome-connections-lang gnome-contacts gnome-disk-utility gnome-extensions-app gnome-font-viewer gnome-mines gnome-music gnome-shortwave gnome-sound gnome-sudoku gnome-system-monitor gnome-tour gnome-tweaks 

# Add Flathub
flatpak remote-add --if-not-exists flathub https://dl.flathub.org/repo/flathub.flatpakrepo

# Install Applications
flatpak install \
com.vscodium.codium \
io.github.zen_browser.zen \
com.spotify.Client \
com.belmoussaoui.Obfuscate \
org.videolan.VLC \
org.nickvision.tubeconverter \
cafe.avery.Delfin \
de.haeckerfelix.Fragments \
org.gnome.gitlab.YaLTeR.VideoTrimmer \
com.github.tchx84.Flatseal \
de.schmidhuberj.Flare \
org.gnome.Fractal \
io.missioncenter.MissionCenter
```