# TKey Setup

> This Gist shows how SudoVanilla utilizes it's own TKey for signing and ssh.\
> ***SudoVanilla is not responible for any damages to your Tillitis TKey, Tillitis Tkey Unlocked, and systems.([&1](#risks))***\
> If this Gist needs correction, feel free to [contact me](https://sudovanilla.org/) as soon as possible.

## What is a TKey?

"[TKey is a compact USB-C device](https://www.tillitis.se/) designed to provide a secure and isolated environment for specialized applications. [Applications](https://www.tillitis.se/download/) are loaded onto TKey and run one at a time in complete isolation, preventing access to the secrets of other applications. This design ensures digital protection for critical tasks such as Authentication, Digital Signing, Secure Random Number Generation, and Encryption."

### Purchase

You can purchase a TKey directly from the [Tillitis shop](https://shop.tillitis.se/products/tkey), where it currently retails for $82 USD as of writing. 

### After purchase, verify your TKey is genuine

(Fedora)
```bash
wget https://github.com/tillitis/tkey-verification/releases/download/v1.0.0/tkey-verification_1.0.0_linux_amd64.rpm
sudo dnf install ./tkey-verification_1.0.0_linux_amd64.rpm
```

Plug in your TKey into your system and run the following:
```bash
tkey-verification verify
```

> If you're already running an application or the light is blue instead of white, please unplug the TKey and plug it back in again to put it in firmware mode.

The message "**`TKey is genuine!`**" should appear if your TKey is legit. The light should be purple as well. Please unplug TKey and plug it back in moving forward, take it out of verification mode.

___

## SSH

You can login to your Linux servers remotely using the TKey, by adding your SSH key on your server. 

Plug in your TKey into your system, then run the following:
```bash
ssh-add -L
```

This should trigger a dialog on your desktop to type in a password, set a strong password you'll use to login to servers via SSH. 

Copy the generated SSH key from your terminal, on your server add it to the `.ssh/authorized_keys` file. Next time you login you can use the Tkey,it should flash green, and simply tap the sensor.

If it starts denying access, you may of typed in the password wrong for your TKey. Unplug your TKey, plug it back in, and try again. The SSH key used by the TKey can change if you use a different password, be sure you're typing in your password correctly([USS](#uss)).
___

## Signing Commits

Download the [signature tool](https://www.tillitis.se/applications/tkey-signature-tool/) and [SSH agent](https://www.tillitis.se/applications/tkey-ssh-agent/), they're required to use your Tkey for signing.

Change your SSH auth sock to use the SSH agent:
```bash
export SSH_AUTH_SOCK="$XDG_RUNTIME_DIR/tkey-ssh-agent/sock" # See config.fish for those using Fish
```

Plug in your TKey into your system, then run the following:
```bash
ssh-add -L
```

This should trigger a dialog on your desktop to type in a password, set a strong password you'll use to sign commits. ***Please advise that using a different password will change the SSH key generated by the TKey, make sure you're typing in the correct password when signing commits in production ([USS](#uss)).***

Once you've settled on a password to use, your SSH key will appear, it'll look somewhat like this:
```bash
ssh-ed25519 AAAAAAAAAAAAAAAAAA00000000000 TKey
```

> Your SSH key generated by your TKey should always end with `TKey` at the end.

Now, setup your git CLI to use that signing key  with SSH format and to always sign by setting `gpg` to true. 

Setup your `.gitconfig` like this:
```
[user]
	email = john.smith@example.org
	name = JohnyS
	signingkey = ssh-ed25519 AAAAAAAAAAAAAAAAAA00000000000 TKey
[commit]
	gpgsign = true
[gpg]
	format = ssh
```

Make changes to a repository, then make a commit and push:
```bash
git commit -m "test"
git push
```

> Tillitis has tools available such as [GitHub SSH](https://tillitis.se/applications/github-ssh/) and [GitLab SSH](https://tillitis.se/applications/gitlab-ssh/), but are not mentioned here as SudoVanilla primarly uses [Forgejo servers](https://forgejo.org/) including it's own [SudoVanilla Ark](https://ark.sudovanilla.org). 

___

## Troubleshooting

If you get the error "`Could now show USS prompt: Pinentry: unexpected response: "S ERROR surses.isatty 83918950"`, after a reboot, then do the following:
```bash
sudo dnf install pinentry-gnome3
nano ~/.gnupg/gpg-agent.conf
```

Add add the line:
```
pinentry-program /usr/bin/pinentry-gnome3
```

Then run:
```bash
gpgconf --kill gpg-agent
gpgconf --launch gpg-agent
```

___

## Footnotes

#### Risks

To maintain availablity to your infrastructure, do not enforce TKey exclusive authentication for SSH unless a verified recovery workflow is in place. Enforcing such requirements without a secondary access method poses a significant risk of permanent lockout, particularly for servers lacking physical access. 

However, if you're going to accept this risk, expect to take full responibility in the case of a server lockout. 

Links to consider reading:
 - [SSH Security Best Practices: Protect Your Remote Access Infrastructure](https://tailscale.com/learn/ssh-security-best-practices-protecting-your-remote-access-infrastructure)
 - [Eight ways to protect SSH access on your system](https://www.redhat.com/en/blog/eight-ways-secure-ssh)

#### USS

When prompted to type in a password for your Tillitis TKey. Unlike traditional security keys where a password only encrypts an existing "static" key, your TKey uses a USS(User Supplied Secret) as the input for key derivation. 

SSH keys are generated with the following:

 - The unique hardware secret inside your device.
 - Exact version (hash) of the TKey device application you're running.
 - USS, the password your typed in.

You can view [this article on TKey Key Genration](https://www.tillitis.se/blog/2023/03/31/on-tkey-key-generation/).

#### Misc

SudoVanilla has integrated the Tillitis TKey to enhance it's own security by using a hardware-based root of trust. This means taht critical operations are protected by this phyical device, preventing sensitive information from being easily stolen and compromised. This approach in using the Tillitis Tkey helps ensure the integrity of source code signatures and infrastructure.

Beyond this, a Yubico Yubikey is deployed across server environments and user accounts wherever possible to provide a rebust multi-factor authentication. For other security actions, there are use cases where a single key may be used multi-times in one go to simply run a single task, or both keys are required for the task(s). 

SudoVanilla takes it's security as seriously as it can to ensure protection over server data and it's contents. 