# Login via SSH Passwordless

Allow yourself to remotely login to your server without the need of typing in the password.

All of the commands listed below are to be run on the client-side only.

## Generate RSA Keypair

Generate an RSA Keypair using `ssh-keygen`, run the following:
```bash
ssh-keygen
```

For all options that'll be propmpt, you can just press Enter and leave your ouput plank. Optionally, you can name the RSA file if you want.

## Copy RSA Keypair to Server

The server will need to know the key as well, copy it with `ssh-copy-id`, run the following:
```bash
ssh-copy-id USERNAME@HOSTNAME
```

## Login
If everything went smoothly, it should of, you'll now be able to login skipping the need to type in a password.

```bash
ssh USERNAME@HOSTNAME
```

> **WARNING**: By leaving SSH keys like this exposed, without encrypting them is not best practice, even if you encrypt your partition where the SSH keyss live. It is actually much safer to continue without this tutorial altogether, requiring yourself to enter the server's password login. Try using, if you prefer, using tools such as Keychain (macOS or Linux), or SSH agent to remember the password until you either logout, suspend, or timeout.

___

This tutorial is based on [jzap](https://serverfault.com/users/67547/lzap)'s [comment](https://serverfault.com/users/67547/lzap) found on Server Fault.