Add multi-architecture support to an OCI image.

> SudoVanilla uses [`buildah`](https://buildah.io/) instead of Docker, as it
> builds valid OCI images that are supported by the SudoVanilla OCI Registry.
> The [SudoVanilla OCI Registry](https://oci.registry.sudovanilla.org/) is
> powered by [Zot Registry](https://zotregistry.dev/), a OCI-native container
> image registry.

## Build or Pull Images

**Build Image**
```bash
buildah build -t registry.org/image:amd64
buildah build -t registry.org/image:amd64
```

**Pull Image**

```bash
buildah pull -t registry.org/image:arm64
buildah pull -t registry.org/image:arm64
```

## Manifest
### Create

Use the `manifest create` command to generate a new OCI image index and give it the `latest` tag name.
```bash
buildah manifest create registry.org/image:latest
```

### Combine Images

Using the previous images that was previously built or pulled, apply them to the newly created manifest:
```bash
buildah manifest add registry.org/image:latest registry.org/image:arm64
buildah manifest add registry.org/image:latest registry.org/image:arm64
```

### Push Image

You can now push the `latest` tag to your preferred registry and it'll be uploaded with both architecture images intact.
```bash
buildah manifest push registry.org/image:latest
```