# Buildah - Build and Push

## Build

To build an OCI image, use the `build` option and name the OCI image with the `-t` tag variable:
```bash
buildah build -t registry.whatever.org/image-name
```

You can also add metadata to it like a description with the `--annotation` variable, by adding:
```bash
--annotation 'org.opencontainers.image.description=Description of the OCI image'
```

> View more metadata options for OCI images: https://github.com/opencontainers/image-spec/blob/main/annotations.md#back-compatibility-with-label-schema

To add another metadata, such as the vendor, you  would simply add another `--annotation` variable. Here's a full example:
```bash
buildah build -t registry.whatever.org/image-name --annotation 'org.opencontainers.image.description=Description of the OCI image' --annotation 'org.opencontainers.image.vendor=Vendor Name'
```

## Push

It's straight-forward with the `push` option. Just push:
```
buildah push registry.whatever.org/image-name
```