# Letter to Netweak
## About

This email explains ideas and features that SudoVanilla is interested in seeing on the service in the future.

___

## Based on Status
![](https://ocean.sudovanilla.org/media/images/Netweak_Status_Concept_Revision_13.png)

There are times where a website is functional and operational, but may return a 404 or a 403 code by default, which Netweak will see as non-operational, labeling the status as "Down". 

For example, a software like Zot will return a 404 code no matter what if the UI is disabled within it's configuration, but is operational none the less. 

What I see, is there could be a list of valid codes as a setting, within an website item. Status codes Netweak can accept as operational. See the image above to get a good idea of what I mean.

## Email Alerts and Subscription
Just like with competitors of Netweak, they provide an option on the status page for the end-user to subscribe to the status page if they're interested in keeping up with alerts. While this is function seems not too complicate to implement, there are a couple things I'll like to see with how Netweak could execute this feature.

First, is allowing a custom SMTP server for "Premium" customers. When setting up the email subscription function in the status page, a "Custom SMTP Server" option should be available, so that emails are going through our email servers instead. I personally use Resend, which is fantastic for developers, Netweak could easily integrate Resend as an option letting the Netweak customer use an API key from their Resend account and an email connected to their Resend account. 

Second, a customizable email format. Allow "Premium" customers to create custom email templates to personalize and tailor the email look to their branding. To make sure emails are setup correctly and shows the information properly, Netweak will need to let the customer know what variables to use like `{%status%}` within the email template.

As an example, a plain text email would look like this:
```html
<p>The website {%website%} is {%status%}.</p>
<a href="{%link%}">Status Page</p>
```

This should set a good example of what I'm trying to talk about.

## Cloudflare Integrations
While SudoVanilla dropped Cloudflare over a year ago and is no longer interested in the service, the idea for an integration could benefit a lot of Netweak customers. 

Netweak could build a Cloudflare App that connects their Cloudflare domain and Netweak together. The app could attempt to use a Netweak API key on the Cloudflare app to connect or authenticate another way as long as it's secure.

By doing this, a status page domain could be setup with ease by the Netweak App automatically applying the required DNS records needed. So if a customer is trying to setup a status page for `uptime.example.org`, this app can the required DNS records for `uptime` on the domain the customer will select, if they have more than 1 Cloudflare domain. 

Another benefit to this, is this could be used to quickly add subdomains to the websites section of the customer's account. Especially helps if they're migrating to Netweak and have a lot of subdomains.

___

## What I don't want to see

One major thing I would like to NOT see in the future of Netweak is the use AI in it's product. The use of AI is overrated, overused, and sometimes isn't thought-through of how to execute it. 

As an enterprise customer, I would delete my account right away if I see a hint of AI being added or is planned to be added. 

___

Korbs,
SudoVanilla