# Stop Using JavaScript, Use These Methods Instead

## Let's Talk First, About the JavaScript Issue

For years now JavaScript continues to be heavily overused for web features and functions that have standardized, native, and high-performance equivalents in HTML and CSS. In today's modern web standards, it now allows developers to replace these complex and unnesesary scripts with simple declarative tags that provide better accessibility and speed. It's also really annoying when developers decide to use entire libraries for these basic tasks such as jQuery and React logic, which I personally have hate torwards.

### Common Overused Scenarios

A lot of these scenarios have had native solutions for years now, although some are more recent than others.

- Dialog Modals and Popups
- Accordions and Toggles
- Tooltips
- Dropdown Menus
- Form Validation
- Scroll-down animations
- Lazy Loading Images
- Complex Page Transitions
- Color Pickers and Complex Inputs
- Responsive Element Sizing

### Consequences

Relying so much on JavaScript for these basic functions introduces a few risks:

 - **Performance "Tax"**: Every 500KB of unused and redundant code can lower a site's performance score by 10 - 20 points. JavaScript can be and is *computationally* "expensive" because it must be downloaded, parsed, and executed, which clogs the browser's main thread and delays rendering time for the webpage. 
 - **Fragility**: JavaScript is less forgiving than how HTML and CSS are. Just a single syntax error can end up breaking an entire webpage's functionality or worse, whereas browsers may often ignore minor errors in markup and styling.
 - **Accessibility Barriers**: Doing custom-built JavaScript components can often fail to manage keyboard focus or screen reader announcements correctly, while native elements have these behaviors "baked in".
 - **CEO and Maintenance**: Relying heavily on script-generated content can hinder search engine indexing. It adds layers of complexity for future maintenance compared to using standard, declarative code.