## Installing Agent on Linux
To install an agent into your Linux machine, [Docker Engine](https://docs.docker.com/engine/install/) is required to be installed.

Once done, create a new folder somewhere on the server and put the following file, named `docker-compose.yml` into it:
```yml
services:
    drone-runner-docker:
        volumes:
            - /var/run/docker.sock:/var/run/docker.sock
        environment:
            - DRONE_RPC_PROTO=https
            - DRONE_RPC_HOST=ci.havoc-browser.app
            - DRONE_RPC_SECRET=7889adbcb17a56b0db9d1be7d320c82c
            - DRONE_RUNNER_CAPACITY=1
            - DRONE_RUNNER_NAME=havoc_linux
            - DRONE_LIMIT_REPOS=korbs/*,havoc-browser/www
        ports:
            - 3200:3000
        restart: always
        container_name: runner
        image: drone/drone-runner-docker:1
```

After that, run it:
```bash
sudo docker compose up -d
```

## Installing Agent on Windows
To install an agent into your Windows machine, Docker Engine is required to be installed.

**I recommend attempting installing the Docker Engine only instead of Docker Desktop**
So, enable the __Windows Subsystem for Linux__ on it and install Docker Engine via WSL.

Once you figure all that, create a new folder somwhere on the server put the following file, named `docker-compose.yml` into it:
```yml
services:
    drone-runner-docker:
        volumes:
            - /var/run/docker.sock:/var/run/docker.sock
        environment:
            - DRONE_RPC_PROTO=https
            - DRONE_RPC_HOST=ci.havoc-browser.app
            - DRONE_RPC_SECRET=7889adbcb17a56b0db9d1be7d320c82c
            - DRONE_RUNNER_CAPACITY=1
            - DRONE_RUNNER_NAME=havoc_windows
            - DRONE_LIMIT_REPOS=korbs/*,havoc-browser/www
        ports:
            - 3200:3000
        restart: always
        container_name: runner
        image: drone/drone-runner-docker:1
```

After that, open a Linux terminal into it, run it:
```bash
sudo docker compose up -d
```