# Zot Docker Setup

Setup Zot in Docker

This is mostly how SudoVanilla's Docker registry is setup.

> I'm still new to Zot, so some information below could be inaccurate and some important information could be missing too.

## Configuration

### Address and Port

Zot will need to bind itself to an address and port.

- `address` - `192.168.0.0` (Use Local IP)
- `port` - `2000`

Example above would bind `http://192.168.0.0:2000`

### Access Control

The already provided configuration is setup to allow guest users to view any images that is available on your Zot registry, with one user(you) being able to view, create, delete, and update images. 

Make sure you give yourself access to other permissions, the email you plan to use should be set to `users` under the `*` policies under `accessControl`.

### OpenID Connect (Optional)

To setup OpenID Connect, configure the `openid` portion of the `config.json` file.

 - `name` - Name that appears on login button (Sign in with `name`)
 - `issuer` - `https://sso.whatever.org/odic` 
    - Don't use the provider configuration endpoint, use the issuer endpoint
 - `clientid` - Client or App ID
 - `clientsecret` - Client or App secret
 - `scopes` - Permissions to give Zot that it can access.

Your Zot redirect URL will look like this:
```
// Path
/zot/auth/callback/oidc

// Full URL example
https://zot.whatever.org/zot/auth/callback/oidc
```

> The endpoint will use your `externalUrl` as the assumed redirect URL, make it is set correctly for your setup.

> If you don't plan to use this, remove the `openid` portion from the `config.json` file.

### Htpasswd (Optional)

If you plan to provide a login via email and password, you'll need to create an account with the `htpasswd` command and create the account you'll use.

Create an account:
```bash
htpasswd -bnB MyUsername MyPassword > ./htpasswd
```

> If you don't plan to use this, remove the `htpasswd` line from the `config.json` file.

## Uploading to your Zot Registry
Zot seems to be setup to accept OCI images, not the Docker format, so using `docker push` won't work.

To build and push a Docker image to your Zot registry, I recommend using the Buildah command line tool. 

Learn how to here: https://gist.sudovanilla.org/Korbs/buildah-build-and-push

> Don't use Skopeo, as it doesn't carry over the `cmd` or `entrypoint` of the Docker image.