## Zot Registry Configuration

Please enable `notation` as a trust option and API keys:
```json
...
  "http": {
    "auth": {
      "apikey": true
    }
  }
  "extensions": {
    "trust": {
      "enable": true,
      "notation": true
    }
  }
...
```


## Notation CLI Setup
### Installation

Install the Notation CLI tool:
```bash
export NOTATION_VERSION=1.3.1
curl -LO https://github.com/notaryproject/notation/releases/download/v$NOTATION_VERSION/notation_$NOTATION_VERSION\_linux_amd64.tar.gz
sudo tar xvzf notation_$NOTATION_VERSION\_linux_amd64.tar.gz -C /usr/local/bin notation
```

Verify installation:
```bash
notation version
```

Setup directories in `.config`:
```
mkdir -p ~/.config/notation/localkeys/
```

Create `signingkeys.json`
```
{
    "default": "DefaultKey",
    "keys": [
        {
            "name": "DefaultKey",
            "keyPath": "/home/YOUR_USERNAME/.config/notation/localkeys/sign.key",
            "certPath": "/home/YOUR_USERNAME/.config/notation/localkeys/sign.crt"
        }
    ]
}
```

> Keys are copied over during instructions in this Gist.

### Registry Login

Login to your Zot Registry:
```
notation login registry.example.org
```

## Generating Certificate Key and Signing

Create the key:
```bash
openssl genpkey -algorithm RSA -pkeyopt rsa_keygen_bits:3072 -key sign.key -out sign.csr
```

Create the certficate file:
```bash
openssl x509 -req -sha256 -days 365 -in sign.csr -signkey sign.key -out sign.crt -extfile (printf "keyUsage=critical,digitalSignature\nextendedKeyUsage=codeSigning" | psub)
```

Copy your keys to notation configuration:
```bash
cp sign.key ~/.config/notation/localkeys
cp sign.crt ~/.config/notation/localkeys
```

Upload the certificate to your Zot Registry via API:
```bash
curl -u "YOUR_USERNAME:YOUR_API_KEY" --data-binary @sign.crt -X POST "https://registry.example.org/v2/_zot/ext/notation?truststoreType=ca"
```

Sign an OCI image that is already on your Zot Registry:
```bash
notation sign registry.example.org/image_name:tag
```