# SudoVanilla Ark and Commit Signing
Sign commits when pushing to SudoVanilla Ark and other Forgejo/Gitea instances.

## Generate SSH Key
Generate a new SSH key using the `ssh-keygen` key. We'll name it `ark` so we know in the future that this key is used for SudoVanilla Ark or whatever you originally planned to use it for. 

Run:
```bash
ssh-keygen -o -f ~/.ssh/ark -a 100 -b 4096 -C "KeyName"
```

> Keep the `passphrase` blank.

> The `KeyName` can be whatever you want it to be. I usually set it as the device's name or related, so I would use something like `Framework-laptop-20241217` sometimes, with date included.

The files should of been generated to the following:
 - Identification: `~/.ssh/ark`
 - Public Key: `~/.ssh/ark.pub`

## Setup Git
Setup Git to match the username and email you use on SudoVanilla Ark:
```bash
git config --global user.email "korbs@sudovanilla.org"
git config --global user.name "Korbs"
```

> Remove `--global` if you want to set this per repository. If so, run the commands within the repository.

Then, setup Git to use SSH to sign each commit:
```bash
git config --global commit.gpgsign true
git config --global gpg.format ssh
git config --global user.signingkey ~/.ssh/ark
```

## Add SSH Key to SudoVanilla Ark
Go to your [Keys settings](https://ark.sudovanilla.org/user/settings/keys) and click "Add Key" for SSH Keys. 

After running the `cat` command, use the output and insert it into the "Content" box. The "Key name" box will be auto-filled, but you can still change it if you want to.
```bash
cat ~/.ssh/ark.pub
```

Now you need to verify the key in the Keys settings of your account, click "Verify". 

Following the on-screen instructions, you'll need to run the following:
```bash
echo -n 'TOKEN_HERE' | ssh-keygen -Y sign -n gitea -f ~/.ssh/ark
```

> A token is generated for you already in the on-screen instructions, no need to generate one manually.

> `gitea` is required, don't change it.

Insert the SSH signanture into the settings and click "Verify". If done correctly, a green message should appear at the top of the page saying it has been verified.

## Completed

That's it. Next time you use commit, it is signed automatically. When you push, you can see a green lock icon indicating that the commit you pushed was successfully signed. 