# Selfhosting Minecraft Java Server

Getting around to selfhosting your own Minecraft Java server has it's perks and gives you full control of your server's data, it's also much more affordable compared to using a SaaS. 

If you have a spare machine laying around that is no longer in use, it would be re-purposed as a Minecraft server.

## Hardware Requirements

For the piece of hardware you'll be using to host the server on, you want to make sure you know it can handle it. For your CPU, it should at least have 4 or more cores over 2GHz. 4GB - 8GB or more RAM(Memory), this also varies how much you add to the server like the amount of players connecting or the many plugins or mods you add. For disk space, I make sure you have at least 8GB or more, this also varies like it does with RAM. 

If you do plan to launch your server publically for many to join, make your internet connection for this machine is decent as well. For this, your upload speed is important, 100Mbps or more for your upload speed should do fine. If it's something like 10Mbps, players may lag a bit every now and then, but if the hardware is stable enough and too much isn't happening, it may keep up just a tad, but not recommended.

## Software Requirements
For what operating system the machine should be running, using something like Linux would be preferred as it's much more lightweight and less bloated than Microsoft Windows. If this machine is for server-purpose only, then it should be a server OS, with no GUIs pre-installed, since GUIs like a desktop environment can add onto the RAM and disk space alone.

For what Linux distro you should use, this shouldn't matter too much for hosting a Minecraft operating system. This tutorials will should steps for at least Debian, RHEL(Fedora/CentOS), and Alpine Linux. 

As for what should be installed on the Linux operating system, you'll need at least Java installed. This will be the first step listed.

___

## Step 1 - Java Installation

> We'll use also install `wget`, that'll be used in the next time.

**Debian/Ubuntu**

To install Java, run the following commands:
```bash
apt update
apt install default-jre default-jdk wget
```

**RHEL**

To install Java, run the following:
```bash
dnf update
dnf install java wget
```

**Alpine Linux**

To install Java, run the following:
```ash
apk add java wget
```

## Step 2 - Download Minecraft Server Software

Before we do download the server software, let's first decide on where to put the server. Create a directly for the server, for this tutorial, we'll use the user's home folder.

To create a directory for the server, which we'll called `mcserver` for this tutorial, run the `mkdir` command:
```bash
mkdir ~/mcserver/
```

Then, use the `cd` command to change directory within the terminal:
```bash
cd ~/mcserver
```

Now, with `wget`, we can use it to download the server software to the server. The server runs simply from a __.jar__ file, as all Minecraft Java servers do, to download it to the folder run the following:
```bash
wget https://piston-data.mojang.com/v1/objects/e6ec2f64e6080b9b5d9b471b291c33cc7f509733/server.jar
```

> The link is pulled from the [official website](https://www.minecraft.net/en-us/download/server), right-click the `.jar` link and copy link to get it. This tutorial was written as of 1.21.5, so the link used in the command is for Minecraft Java 1.21.5.

This should download the file needed, it should be outputted to the folder now as __server.jar__. You can confirm by running the list files command in the terminal:
```bash
ls
```

If you see the __server.jar__ file, you've successfully downloaded what's needed.

## Step 3 - Starting the Server

To run the server, `java` is used while targetting the __server.jar__ file, we can simply run:
```bash
java -jar server.jar
```

This will run the server, since it's brand new it'll generate the needed files. Since this will be the first run, the server will quit automatically after it generates the __EULA.txt__ file, as you're required to agree to it.

Edit the __EULA.txt__ file, with `nano` or your preferred terminal editor, and change `false` to `true`.
```bash
nano EULA.txt
```

To save, with `nano`, press `Ctrl` + `O`, then `Enter`. To exit the editor, `Ctrl` + `X`.

Now, run the first command again and it'l generate the world and the server will be running:
```bash
java -jar server.jar
```

Please note that you should use it like that in production, there are tons of other paremeters that can be added to optimize your Minecraft Java server, use https://flags.sh/ to get an optimize launch command. 

Congrats! If everything went smoothly, your Minecraft Java server is now running.

## Step 4 - Joining the Server

Okay, now we need to figure out how to join the server over your local network(if the server is locally within your home network). We can get the server's IP address and use it to join the server from our Minecraft client(the game itself).

To retrieve the local IP address of the server, run the following command:
```bash
ip addr show
```

You may see a lot or a few connection in the output, if your server is connected over Ethernet you'll want to look at the `eth0` connection, or it may be called `eth1`. Look for an local IP address that should begin with `192.168.`, this will be your server's local IP address. If it's over WiFi, the connection name beings with `wlp`.

For this tutorial, we'll pretend that the server's local IP address will be `192.168.1.114`. This means, you can use `192.168.1.114` or `192.168.1.114:25565` to connect to the server in Minecraft.