# Web Tricks and Methods

## HTML
### Number Keyboard for Mobile Devices

When it comes to creating a number input, we would create an `<input/>` with the `type` attribute set to `number`. This makes arrow buttons show up that can let us go up and down. 

On mobile, we don't want this. It's expected by the end-user that their numberic keyboard shows up, so we set the `inputmode` instead.

```html
<input type="number" inputmode="numberic"/>
```

We could also change the `type` attribute to `text` to get rid of the arrows if we want to.

## CSS
### Outline vs Outline Color

We all decided at some point to set the `outline` option to the `none` variable for our buttons, this is probably because we came up with our own thing with another method like the use of `box-shadow` or something else. 

I don't recommend continuing overriding the default `outline` option, that's because if an end-user uses high-contrast on their operating system, these other methods like `box-shadow` won't show up for them. 

Instead, we should be using `outline-color` instead to get ride of the ugly outline color. Doing so will help end-users that use high-contrast.

```css
/* Don't */
.classname {
  outline: none;
}

/* Do */
.classname {
  outline-color: transparent;
}
```

### Debugging

When we're debugging a function or something else in JavaScript, we tend to use the good old `console.log()` method. However, we can't really do much with this method when it comes to debugging CSS, as there's very little that JavaScript can do to help us. 

As example, if the horizontal scrollbar shows up when nothing appears at first to long enough to cause this. We can use this method to figure out what's causing this.

We can slap an outline on all elements and see their width, height, and other aspects when doing this. This can help us figure out why in the example provided the horizontal scrollbar showed up.

```css
* {
  background: rgba(100,100,100,0.25);
}
```

### Centering DIV

There are many ways now to center an element on screen, here are a few that I used over the past 7 years.

**Old Fashion**

```css
.classname {
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
}
```

```css
.classname {
  position: absolute;
  top: 50%;
  left: 50%;
  translate: -50% -50%;
}
```

```css
.classname {
  position: absolute;
  inset: 0;
  margin: auto;
}
```

> For all old fashion versions, if you're trying to center an element inside of a DIV, make sure that DIV's position is already set to `relative`.

**Flex**

```css
.classname {
  display: flex; /* "grid" also works here too */
  justify-content: center;
  align-items: center;
}
```
**Margin**

```css
.classname {
  margin: auto;
}
```

### Light / Dark Theming

**Media Method**

```css
@media (prefers-color-scheme: dark) {
  .classname {
    background: #000000;
  }
}
```

**Newer `light-dark` Method**

Use the `light-dark` CSS function. The first color you set is for the light theme and the second color is for the dark theme.

```css
.classname {
  background: light-dark(#FFFFFF,#000000);
}
```

```css
.classname {
  background: light-dark(rgb(255,255,255), rgb(0,0,0));
}
```