During the day, I happen to switch between my speakers and headphones quite a bit. I've recently decided to setup custom shortcuts to switch quickly between them without needing to open the volume menu in GNOME or KDE.

## Install

Firstly, the `pactl` tool is used for this, please install it:

```
sudo dnf install pactl
```

## List

Then, list your outputs:
```bash
pactl list short sinks
```

Here's what mine looks like:
```bash
51	alsa_output.usb-KTMicro_KT_USB_AUDIO_214b206000000178-00.analog-stereo	PipeWire	s24le 2ch 48000Hz	SUSPENDED
52	alsa_output.pci-0000_00_1f.3.analog-stereo	PipeWire	s32le 2ch 48000Hz	RUNNING
```

KTMico is an Anker USB hub with an 3.5mm jack, the PCI is the one that is builtin to my laptop.

## Switching

To switch between outputs, use the `set-default-sink`.

As an example, this is what I use to switch to my laptop's builtin AUX port/speakers:
```bash
pactl set-default-sink alsa_output.pci-0000_00_1f.3.analog-stereo
```

## Setup Keyboard Shortcut

Using the keyboards settings in your Linux's DE, you can apply these commands to a custom shortcut. 

For my case, I did the following:
 - `Shift` `Alt` `Numpad1` - Switch to PCI (Laptop's AUX/Speakers)
 - `Shift` `Alt` `Numpad2` - Switch to External Speakers (USB C Hub's AUX)

You can adapt to the way you want it, does not need to be like the way I have it.