![](https://md.sudovanilla.org/images/svg-2.gif)

## Requirements
 - ffmpeg
 - NodeJS

## Script

In a new directory, create a file called `generate.js`, then install the `sprite-vtt-generator` package:

```bash
npm install sprite-vtt-generator
```

For the `generate.js` file, put in the following:

```js
import { SpriteGenerator } from "sprite-vtt-generator"
const spriteGenerator = new SpriteGenerator({
    inputPath: "./video.mp4",
    outputDir: "./",
    width: 180,
    height: 101,
    rowCount: 10,
    colCount: 5,
    multiple: false,
    interval: 3,
    thumbnailPrefix: "thumb",
    webVTT: {
        required: true,
        path: "./storyboard.vtt"
    }
})

await spriteGenerator.generate()
```

## Generate

Add the video you want to use and rename to `video.mp4` (or change `inputPath` in `generate.js`).

Then run the script:

```bash
node generate.js
```

For testing, I used Ennie and Yoyki full episode, which out as this: https://ocean.sudovanilla.org/media/images/159.jpg